<?php
include_once __DIR__ . '/../auth_check.php';
include_once __DIR__ . '/../config/db.php';

$adminId = $_SESSION['admin_id'];
$role    = $_SESSION['admin_role'];

$today = date('Y-m-d');

/* ================= SUMMARY ================= */
if ($role === 'SUPER') {

    $sumSql = "
        SELECT 
            COUNT(id) AS total_payments,
            SUM(amount) AS total_amount
        FROM payments
        WHERE DATE(payment_date) = ?
    ";
    $sumStmt = $conn->prepare($sumSql);
    $sumStmt->bind_param("s", $today);

} else {

    $sumSql = "
        SELECT 
            COUNT(p.id) AS total_payments,
            SUM(p.amount) AS total_amount
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE c.admin_id = ?
          AND DATE(p.payment_date) = ?
    ";
    $sumStmt = $conn->prepare($sumSql);
    $sumStmt->bind_param("is", $adminId, $today);
}

$sumStmt->execute();
$summary = $sumStmt->get_result()->fetch_assoc();
$sumStmt->close();

/* ================= DETAILS ================= */
if ($role === 'SUPER') {

    $detailSql = "
        SELECT
            p.payment_date,
            p.amount,
            b.id AS bill_id,
            c.`Name`        AS customer_name,
            c.`Account No`  AS account_no,
            c.`VC Number`   AS vc_number,
            c.`Mobile No`   AS mobile
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE DATE(p.payment_date) = ?
        ORDER BY p.payment_date DESC
    ";
    $detailStmt = $conn->prepare($detailSql);
    $detailStmt->bind_param("s", $today);

} else {

    $detailSql = "
        SELECT
            p.payment_date,
            p.amount,
            b.id AS bill_id,
            c.`Name`        AS customer_name,
            c.`Account No`  AS account_no,
            c.`VC Number`   AS vc_number,
            c.`Mobile No`   AS mobile
        FROM payments p
        JOIN bills b ON p.bill_id = b.id
        JOIN customers c ON b.customer_id = c.id
        WHERE c.admin_id = ?
          AND DATE(p.payment_date) = ?
        ORDER BY p.payment_date DESC
    ";
    $detailStmt = $conn->prepare($detailSql);
    $detailStmt->bind_param("is", $adminId, $today);
}

$detailStmt->execute();
$detailResult = $detailStmt->get_result();
$detailStmt->close();
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Today Collection Report</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-4">

    <h3 class="mb-3">Today Collection Report</h3>
    <p class="text-muted">Date: <strong><?= date('d M Y') ?></strong></p>

    <!-- ================= SUMMARY CARDS ================= -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <h6>Total Payments</h6>
                    <h3><?= (int)($summary['total_payments'] ?? 0) ?></h3>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body text-center">
                    <h6>Total Amount</h6>
                    <h3 class="text-success">
                        ₹<?= number_format((float)($summary['total_amount'] ?? 0), 2) ?>
                    </h3>
                </div>
            </div>
        </div>
    </div>
<a href="export_today_collection_excel.php" class="btn btn-success">
    Export Excel
</a>

<a href="export_today_vc.txt.php" class="btn btn-dark ms-2">
    Export VC TXT
</a>

    <!-- ================= DETAIL TABLE ================= -->
    <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle">
            <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Time</th>
                <th>Customer</th>
                <th>Account No</th>
                <th>VC No</th>
                <th>Mobile</th>
                <th>Bill ID</th>
                <th>Paid Amount</th>
            </tr>
            </thead>
            <tbody>

            <?php if ($detailResult->num_rows > 0): ?>
                <?php $i=1; while ($row = $detailResult->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= date('h:i A', strtotime($row['payment_date'])) ?></td>
                        <td><?= htmlspecialchars($row['customer_name']) ?></td>
                        <td><?= htmlspecialchars($row['account_no']) ?></td>
                        <td><?= htmlspecialchars($row['vc_number']) ?></td>
                        <td><?= htmlspecialchars($row['mobile']) ?></td>
                        <td>#<?= $row['bill_id'] ?></td>
                        <td class="fw-bold text-success">
                            ₹<?= number_format($row['amount'],2) ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="8" class="text-center text-muted">
                        No collections today
                    </td>
                </tr>
            <?php endif; ?>

            </tbody>
        </table>
    </div>

    <a href="../dashboard.php" class="btn btn-secondary mt-3">Back</a>

</div>

</body>
</html>
